/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.ui;

import org.eclipse.core.runtime.IAdaptable;

/**
 * Interface that describes a mechanism that may be provided by working set
 * implementors to help manage the addition of elements to working sets.
 * Instances of this class are capable of transforming possible working set
 * content into the most applicable form.
 * 
 * @since 3.3
 */
public interface IWorkingSetElementAdapter {

	/**
	 * Converts the given elements for addition to /removal from the working
	 * set.
	 * 
	 * @return the (possibly adapted) elements to add to /remove from the
	 *         working set
	 */
	IAdaptable[] adaptElements(IWorkingSet ws, IAdaptable[] elements);
	
	/**
	 * Disposes of this element adaptor.
	 */
	void dispose();
}